/* ==========================================================

Please review the /readme.md for a more details.

========================================================== */


const jsonURL = document.querySelector("#product-detail-wrapper").dataset.path;

// URL from which to fetch the JSON data
const url = jsonURL;

// Function to render HTML template
function displayData(data) {
  const item = data.data.baseProductByPath.item;

  const productDetails = item.productDetails.map(detail => {
    return `<li><span>${detail.productDetailDisplayLabel}:</span> ${detail.productDetailFieldValue.plaintext}</li>`;
  }).join('');

  const applications = item.localizedProductFeature.applications;

  const specifications = item.productSpecification.map(spec => {
    return `<li><span>${spec.specificationLabel}</span> ${spec.specifcationMeasureImperial} | ${spec.specifcationMeasureMetric}</li>`;
  }).join('');

  const resources = item.productResources.map(res => {
    return res.resourceLabel ? `<li><span>${res.resourceLabel}:</span> <a title="${res.resourceLabel}" href="${res.resourceLink ? res.resourceLink._publishUrl : '#'}">${res.resourceLink ? res.resourceLink._publishUrl : '#'}</a></li>` : '';
  }).join('');

  // Sort and group productImages by imageCategory
  const sortedImages = [...item.productImages].sort((a, b) => a.imageCategory.localeCompare(b.imageCategory));

  const images = sortedImages.reduce((acc, imageGroup) => {
    const category = imageGroup.imageCategory;
    if (!acc[category]) {
      acc[category] = [];
    }
    acc[category].push(imageGroup);
    return acc;
  }, {});

  const imageHtml = Object.keys(images).map(category => {
    const variantsHtml = images[category].map(imageGroup => {
      const variantBlocks = imageGroup.imageVariants.map(variant => {
        return `
                    <li><a href="${variant.imageLink}" title="${variant.imageLabel}" target="_blank">${variant.imageLabel} <i class="fas fa-link"></i></a></li>
            `;
      }).join('');
      return `<div class="product-image-group"><img src="${imageGroup.imageThumbnail}" alt="${imageGroup.imageCategory}" /><ul>${variantBlocks}</ul></div>`;
    }).join('');
    return `<div class="image-section"><h3>${category}</h3><div class="product-image-variants">${variantsHtml}</div>`;
  }).join('');

  const template = `
                <div class="content">
                    <div class="product-details-information">
                      <div class="product-image">
                        <img class="api-image" style="width:420px; margin-top:15px;" src="${item.productImages[0].imageVariants[0].imageLink}">
                      </div>
                      <div class="product-information"> 
                        <h1 class="api-text">${item.productSeries.seriesId}</h1>                        
                        <h3 class="api-text">${item.productDetails[1].productDetailFieldValue.plaintext}</h3>
                        <p class="api-text">${item.productDetails[2].productDetailFieldValue.plaintext}</p>                                               
                        <div class="button-styles">
                          <a href="https://www.crown.com/en-us/forklift-dealers.html">Request A Quote</a>
                        </div>
                        <div class="data-table example2">
                        <div class="table-heading"><h3>Product Specifications</h3><div>
                              <div class="data-entry">
                                <div class="data-header color">
                                  <p class="api-text">${item.localizedProductFeature.forkliftTypeDisplayLabel}</p>
                                </div>
                                <div class="data-info color">
                                  <p class="api-text">${item.localizedProductFeature.forkliftType}</p>
                                </div>
                                <div class="data-header">
                                  <p class="api-text">${item.localizedProductFeature.powerTypeDisplayLabel}</p>
                                </div>
                                <div class="data-info">
                                  <p class="api-text">${item.localizedProductFeature.powerType}</p>
                                </div>
                                <div class="data-header color">
                                  <p class="api-text">${item.localizedProductFeature.operatingPositionDisplayLabel}</p>
                                </div>
                                <div class="data-info color">
                                  <p class="api-text">${item.localizedProductFeature.operatingPosition}</p>
                                </div>
                                <div class="data-header">
                                  <p class="api-text">${item.localizedProductFeature.mastTypeDisplayLabel}</p>
                                </div>
                                <div class="data-info">
                                  <p class="api-text">${item.localizedProductFeature.mastType}</p>
                                </div>
                                <div class="data-header color">
                                  <p class="api-text">${item.productSpecification[0].specificationEnglishFieldId}</p>
                                </div>
                                <div class="data-info color">
                                  <p class="api-text">${item.productSpecification[0].specifcationMeasureImperial}</p>
                                </div>
                                <div class="data-header">
                                  <p class="api-text">${item.productSpecification[1].specificationEnglishFieldId}</p>
                                </div>
                                <div class="data-info">
                                  <p class="api-text">${item.productSpecification[1].specifcationMeasureImperial}</p>
                                </div>
                                <div class="data-header color">
                                  <p class="api-text">${item.productSpecification[2].specificationEnglishFieldId}</p>
                                </div>
                                <div class="data-info color">
                                  <p class="api-text">${item.productSpecification[2].specifcationMeasureImperial}</p>
                                </div>
                                <div class="data-header">
                                  <p class="api-text">${item.productSpecification[4].specificationLabel}</p>
                                </div>
                                <div class="data-info">
                                  <p class="api-text">${item.productSpecification[4].specifcationMeasureImperial}</p>
                                </div>
                                <div class="data-header color">
                                  <p class="api-text">${item.productSpecification[5].specificationLabel}</p>
                                </div>
                                <div class="data-info color">
                                  <p class="api-text">${item.productSpecification[5].specifcationMeasureImperial}</p>
                                </div>
                                <div class="data-header">
                                  <p class="api-text">${item.productSpecification[6].specificationLabel}</p>
                                </div>
                                <div class="data-info">
                                  <p class="api-text">${item.productSpecification[6].specifcationMeasureImperial}</p>
                                </div>                                                                
                                <div class="downloadSpecLink">
                                  <a target="_blank" href="${item.productResources[1].resourceLink._publishUrl}">Download Specifications</a>
                                </div>
                                <div class="downloadBroLink">
                                  <a target="_blank" href="${item.productResources[2].resourceLink._publishUrl}">Download Brochures</a>
                                </div>                   
                                </div>
                            </div>                           
                      </div>
                    </div>
                </div>
            `;
  document.getElementById('data-container').innerHTML = template;
}

fetch(url)
  .then(response => {
    if (!response.ok) {
      throw new Error('Network response was not ok ' + response.statusText);
    }
    return response.json();
  })
  .then(data => {
    displayData(data);
  })
  .catch(error => {
    document.getElementById('data-container').innerHTML = '<p>Error loading data. Please try again later.</p>';
    console.error('Fetch error:', error);
  });
